<?php defined('SYSPATH') or die('No direct script access.');

class Task_Indexer_Srw extends Minion_Task {

    protected function _execute(array $params){
        $records = DB::select('id', 'link', 'client_id')
            ->from('logpost')
            ->where('id', '>', Helper::getCounter('srw'))
            ->limit(20)
            ->order_by('id', 'asc')
            ->execute()
            ->as_array();

        foreach ($records as $record){
            $host = str_ireplace('www.', '', parse_url($record['link'], PHP_URL_HOST));
            $srw = DB::select('host')
                ->from('srw')
                ->where('host', '=', $host)
                ->execute()
                ->as_array(null, 'host');
            if(empty($srw)){
                $gearman = Task_Helper::getSrwClient();
                $gearman->setCompleteCallback(function ($task) use($srw) {
                    if ($task->data()) {
                        $value = json_decode($task->data(), true);
                        $id = DB::insert('srw', array_keys($value))
                            ->values($value)
                            ->execute()[0];

                        DB::insert('luhn', ['id', 'client_id', 'srw_id'])
                            ->values([$value['id'], $value['client_id'], $id])
                            ->execute(Helper::getCurrentSphinx());
                    }
                });
                $gearman->addTask("Srw:LinkInfo", $host, null, md5($host));
                $gearman->runTasks();
            }
        }
    }
}
